/*------------------------------------------------------------------------------*
 * File Name: JCAMPFile.h				 										*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp. 2006, 2007, 2008								*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Cheney 2006-12-15 READ_JCAMP_DATA											*
 *	Hong 07/16/08 v8.0902c FIX_JCAMP_IMPORT_FAIL_AVOID_DUPLICATE_SHEEET_NAME	*
 *	Hong 07/01/09 QA80-13858 FAIL_IMPORT_JCAMP_FILE_WHICH_USE_COMMA_AS_DECIMAL	*
 *------------------------------------------------------------------------------*/

 
#ifndef _JCAMP_FILE_H
#define _JCAMP_FILE_H

enum {
	JCAMP_WARN_Y_VAL_CHECK_NOT_EQUAL 	= 1,
	JCAMP_NO_ERROR				 		= 0,
	JCAMP_ERR_INVALID_FILE				= -1, 
	JCAMP_ERR_UNSUPPORT_DATA			= -2,
	///Cheney 2006-12-15 READ_JCAMP_DATA
	JCAMP_ERR_INVALID_VAR_TYPR			= -3,
	JCAMP_ERR_INVALID_DATA_TYPR			= -4,
	///end READ_JCAMP_DATA
};

/// Hong 07/16/08 v8.0902c FIX_JCAMP_IMPORT_FAIL_AVOID_DUPLICATE_SHEEET_NAME
enum
{
	JCAMP_RENAME_SHEET_BY_FILENAME		= 0x00000001;
};
/// end FIX_JCAMP_IMPORT_FAIL_AVOID_DUPLICATE_SHEEET_NAME

class JCAMPFile : public stdioFile
{
public:
	JCAMPFile(LPCTSTR lpszFileName, bool bImport = true);
	~JCAMPFile();
public:
	BOOL 	Open(LPCTSTR lpszFileName);	
	int 	ReadHeader(TreeNode& trInfo);
	/// Hong 07/16/08 v8.0902c FIX_JCAMP_IMPORT_FAIL_AVOID_DUPLICATE_SHEEET_NAME
	//int		Import(Worksheet& wks, TreeNode& trInfo, int nC1 = 0, DWORD dwOption = 0);
	int		Import(Worksheet& wks, TreeNode& trInfo, int nC1 = 0, DWORD dwOption = JCAMP_RENAME_SHEET_BY_FILENAME);
	/// end FIX_JCAMP_IMPORT_FAIL_AVOID_DUPLICATE_SHEEET_NAME
	///Cheney 2006-12-15 READ_JCAMP_DATA
	//int 	ReadData();
	int 	ReadData(Worksheet& wks, int nC1 = 0, DWORD dwOption = 0);
	bool	Get3dDataFlag(){ return m_b3dData}
	///end READ_JCAMP_DATA
protected:
	int 	getRecord();
	///Cheney 2006-12-15 READ_JCAMP_DATA
	int 	getDataVarType(TreeNode& trData);
	double 	getDeltaX(TreeNode& trHeader, int nPosition);
	int 	getDataType(int nDataPos);
	int 	getDataFromLineXYY(char* pstr, LPCSTR lpcszXColRange, LPCSTR lpcszYColRange, double dDeltaX);
	void	handleUserParameters(TreeNode& trHeader, Column& colx, Column& coly, int nPageIndex);
	void 	handleUserInfo(TreeNode& trHeader, Column& colx, Column& coly, double dDeltaX, bool bYColVarTypeXIII);
	int		getAddColumnsNum(int nVarType);
	void	prepareTreeInfo();
	bool	prepareLabels();
	bool	prepareUnits();
	bool	prepareFactors();
	void	handelFactor(vector& vx, vector& vy);
	bool	checkIf3dData();
	bool	checkIfMultiFraction();
	///end READ_JCAMP_DATA

private:
	//vector<string> m_vsRecord;
	int 		m_nDataIndexStart;
	TreeNode	m_trHeader;
	TreeNode	m_trData;
	///Cheney 2006-12-15 READ_JCAMP_DATA
	int			m_nDataIndexEnd;
	int			m_nCurrentVarType; //may be has some data sections, e.g. data class is DATATABLE
	int			m_nCurrentDataType; //may be has some data sections,e.g. data class is DATATABLE
	int			m_nMaxRows;  //each section may have different rows, use max rows to set wks size
	LPCTSTR 	m_lpszFileName;
	StringArray m_saLabels;
	StringArray m_saUnits;
	vector		m_vFactors;
	bool		m_bHasLabels;
	bool		m_bHasUnits;
	bool		m_bHasFactors;
	bool		m_b3dData;
	vector		m_vPageValue;
	bool		m_bMultiFraction;
	///end READ_JCAMP_DATA
	BOOL		m_bCheckComma; /// Hong 07/01/09 QA80-13858 FAIL_IMPORT_JCAMP_FILE_WHICH_USE_COMMA_AS_DECIMAL
};




#endif   // _JCAMP_FILE_H

